$diff_table_name = ?;
-- Unix epoch, до которого не нужно проверять суммы (позавчера)
$check_before_ts = ?;

$direct_bod_by_cid_date = (
    SELECT ServiceOrderID,
        EventDate,
        SUM(Cost) AS Cost,
        SUM(UndoCost) AS UndoCost,
        MAX(UpdateTime) AS UpdateTime
    FROM `//home/direct/export/balance/BillingOrderDomainsSplittedStat`
    GROUP BY ServiceOrderID, EventDate
);

$bs_hist_bod_by_cid_date = (
    SELECT
        ServiceOrderID,
        EventDate,
        SUM(Cost) AS Cost,
        SUM(UndoCost) AS UndoCost,
        MAX(UpdateTime) AS UpdateTime
    FROM `home/yabs/stat/BillingOrderDomainsSplittedStat`
    WHERE ServiceID = 7
    GROUP BY ServiceOrderID, EventDate
);

INSERT INTO $diff_table_name
SELECT
    COALESCE(dbod.ServiceOrderID, bsbod.ServiceOrderID) AS ServiceOrderID,
    COALESCE(dbod.EventDate, bsbod.EventDate) AS EventDate,
    dbod.Cost AS direct_Cost,
    dbod.UndoCost AS direct_UndoCost,
    dbod.UpdateTime AS direct_UpdateTime,
    bsbod.Cost AS bs_Cost,
    bsbod.UndoCost AS bs_UndoCost,
    bsbod.UpdateTime AS bs_UpdateTime
FROM $direct_bod_by_cid_date AS dbod
    FULL JOIN $bs_hist_bod_by_cid_date AS bsbod
        ON (bsbod.ServiceOrderID = dbod.ServiceOrderID AND bsbod.EventDate = dbod.EventDate)
WHERE
    COALESCE(dbod.EventDate, bsbod.EventDate) < $check_before_ts -- не считая сегодня и вчера
    AND (
        dbod.ServiceOrderID IS NULL
        OR bsbod.ServiceOrderID IS NULL
        OR dbod.Cost != bsbod.Cost
        OR dbod.UndoCost != bsbod.UndoCost
    )
ORDER BY ServiceOrderID, EventDate;

COMMIT;

SELECT
    COUNT_IF(bs_Cost IS NULL) AS bs_missing,
    COUNT_IF(direct_Cost IS NULL) AS direct_missing,
    COUNT_IF(direct_Cost < bs_Cost) AS direct_less_cost,
    COUNT_IF(mult_Cost > 1 AND mult_Cost < 2) AS mult_Cost_1_to_2,
    COUNT_IF(mult_Cost >= 2 AND mult_Cost < 3) AS mult_Cost_2_to_3,
    COUNT_IF(mult_Cost >= 3) AS mult_Cost_3_to_inf,
    COUNT_IF(mult_UndoCost > 1 AND mult_UndoCost < 2) AS mult_UndoCost_1_to_2,
    COUNT_IF(mult_UndoCost >= 2 AND mult_UndoCost < 3) AS mult_UndoCost_2_to_3,
    COUNT_IF(mult_UndoCost >= 3) AS mult_UndoCost_3_to_inf,
    SUM(IF(mult_Cost > 1 AND mult_Cost < 2, direct_Cost - bs_Cost, 0)) AS sum_diff_Cost_1_to_2,
    SUM(IF(mult_Cost >= 2 AND mult_Cost < 3, direct_Cost - bs_Cost, 0)) AS sum_diff_Cost_2_to_3,
    SUM(IF(mult_Cost >= 3, direct_Cost - bs_Cost, 0)) AS sum_diff_Cost_3_to_inf,
    SUM(IF(mult_UndoCost > 1 AND mult_UndoCost < 2, direct_UndoCost - bs_UndoCost, 0)) AS sum_diff_UndoCost_1_to_2,
    SUM(IF(mult_UndoCost >= 2 AND mult_UndoCost < 3, direct_UndoCost - bs_UndoCost, 0)) AS sum_diff_UndoCost_2_to_3,
    SUM(IF(mult_UndoCost >= 3, direct_UndoCost - bs_UndoCost, 0)) AS sum_diff_UndoCost_3_to_inf,
FROM (
    SELECT
        direct_Cost,
        direct_UndoCost,
        bs_Cost,
        bs_UndoCost,
        IF(bs_Cost > 0 AND direct_Cost IS NOT NULL,
            CAST(direct_Cost AS Double) / CAST(bs_Cost AS Double),
            0
        ) AS mult_Cost,
        IF(bs_UndoCost > 0 AND direct_UndoCost IS NOT NULL,
            CAST(direct_UndoCost AS Double) / CAST(bs_UndoCost AS Double),
            0
        ) AS mult_UndoCost,
    FROM $diff_table_name
) AS sub
