$check_time = ?;--test_value="2019-07-26 15:44";
$output_path = ?;--test_value="//home/direct/tmp/noreply";

-- Список продуктов Директа
$products =  "//home/direct/db/products";
-- Список клиентов, которые НЕ попадают под проверку по какой-либо причине
$black_list_client_ids = AsList(0); -- фейк пока
-- Список типов групп, для которых НЕ нужно мониторить боиды (пока)
$black_list_group_type = AsList('cpm_geoproduct');

$isBlackListGroupType = ($type) -> {
    return ListAny(ListMap(Unwrap($black_list_group_type), ($x) -> {
        RETURN $type == $x
    }))
};

$isBlackListClientID = ($client_id) -> {
    return ListAny(ListMap(Unwrap($black_list_client_ids), ($x) -> {
        RETURN $client_id == $x
    }))
};

-- форматирование даты
$shift_period = DateTime::IntervalFromMinutes(30);  -- актуальность в минутах даты обновления кампаний
$parse = DateTime::Parse("%Y-%m-%d %H:%M");         -- парсинг даты запуска скрипта
$parse2 = DateTime::Parse("%Y-%m-%d %H:%M:%S");     -- парсинг даты редактирования кампании
$check_time_as_date = DateTime::MakeDatetime($parse($check_time));

$client_products = (
    SELECT
        c.ClientID as ClientID,
        c.wallet_cid as wallet_cid,
        AGGREGATE_LIST(c.ProductID) as prods,
        AGGREGATE_LIST(p.type) as prod_types
    FROM LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/campaigns`) as c
    JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/wallet_campaigns`) as wc ON wc.wallet_cid = c.wallet_cid
    JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/camp_options`) as co ON co.cid = c.cid
    join $products as p on p.ProductID = c.ProductID
    WHERE c.type = 'billing_aggregate'
        AND wc.is_sum_aggregated = 'Yes'
        AND $isBlackListClientID(c.ClientID) = false
        AND DateTime::MakeDatetime($parse2(co.create_time)) < $check_time_as_date - $shift_period
    GROUP BY c.ClientID, c.wallet_cid as wallet_cid
);

$client_phrases_type = (
    SELECT
        c.ClientID as ClientID,
        c.wallet_cid as wallet_cid,
        AGGREGATE_LIST(ph.adgroup_type) as phrases_types
    FROM LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/campaigns`) as c
    JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/phrases`) as ph on ph.cid = c.cid
    JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/camp_options`) as co ON co.cid = c.cid
    WHERE c.type = 'cpm_banner'
        AND $isBlackListGroupType(ph.adgroup_type) = false
        AND DateTime::MakeDatetime($parse2(co.create_time)) < $check_time_as_date - $shift_period
    GROUP BY c.ClientID, c.wallet_cid as wallet_cid
);

$all_clients = (
    select * from (
        select
            cp.ClientID as ClientID,
            cp.wallet_cid as wallet_cid,
            SetIncludes(ToSet(prod_types), ToSet(phrases_types)) as res,
            String::JoinFromList(DictKeys(
                ToSet(prod_types)
            ), ",") as product_types,
            String::JoinFromList(DictKeys(
                ToSet(phrases_types)
            ), ",") as adgroup_types,
        from $client_products as cp
        join $client_phrases_type as cpt on cp.wallet_cid = cpt.wallet_cid
    )
);

$total_clients_cnt = select count(*) from $all_clients;
$failed_clients_cnt = select count(*) from $all_clients where res = false;

select
    $total_clients_cnt as total_clients_cnt,
    $failed_clients_cnt as failed_clients_cnt;

insert into $output_path with truncate
select
    $check_time as check_time,
    ClientID,
    adgroup_types,
    product_types,
    wallet_cid
from $all_clients
where res = false;
