#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import re
import yatest.common
from collections import defaultdict
from yql.api.v1.client import YqlClient
from yt import yson
from yt_yql_utils import prepare_tables, read_tables

test_resources = 'direct/jobs/ut-local-yql/resources/mobileappssyncjob'

logging.basicConfig(level=logging.DEBUG)

itunes_table_path = "//home/extdata/mobile/itunes"
itunes_table_name = "latest"
gplay_table_path = "//home/extdata/mobile/google_play/latest"
gplay_ru_table = "ru"

output_table_itunes = '//output/itunes'
output_table_gplay = '//output/gplay'


def run_and_compare_result(ytw, client, request, expected_path, output_table):
    response = client.query(request, syntax_version=1)
    response.run()
    print("*************** RESPONSE *****************")
    for row in str(response).split('\\n'):
        print(row)

    result = [row for row in read_tables(ytw, output_table)]
    print("*************** OUTPUT *****************")
    for row in result:
        print(row)

    expected = defaultdict(dict)
    with open(yatest.common.source_path(expected_path)) as f:
        expected_list = [yson.loads(row.strip().strip(';')) for row in f.readlines()]
        print("*************** EXPECTED *****************")
        for value in expected_list:
            print(value)
            expected[value['app_id']][value['lang']] = value

    for row in result:
        assert row == expected[row['app_id']][row['lang']]


def make_request(request_template, request_table_subst, output_table, input_table):
    with open(yatest.common.source_path(request_template)) as f:
        request_template = '\n'.join(f.readlines()).encode('utf-8')
    with open(yatest.common.source_path(request_table_subst)) as f:
        select_table_template = f.readline().encode('utf-8')
    request = re.sub(r'%\(select_parts\)', select_table_template, request_template)
    request = re.sub(r'%\(tablepath\)', '/'.join(input_table), request)
    request = re.sub(r'%\(tmppath\)', output_table, request)
    print("*************** REQUEST *****************")
    print(str(request))
    return request


def test_itunes(yt, yql_api):
    ytw = yt.yt_wrapper
    client = YqlClient(
        server='localhost',
        port=yql_api.port,
        db='plato'
    )
    prepare_tables(ytw, "%s/itunes_data.yson" % test_resources, itunes_table_path, itunes_table_name)
    request = make_request("direct/jobs/src/main/resources/mobileappssync/itunes.yql",
                           "direct/jobs/src/main/resources/mobileappssync/itunes_select_part_tmpl.yql",
                           output_table_itunes,
                           input_table=(itunes_table_path, itunes_table_name))
    run_and_compare_result(ytw, client, request,
                           '%s/itunes_expected.yson' % test_resources,
                           output_table_itunes,)


def test_gplay(yt, yql_api):
    ytw = yt.yt_wrapper
    client = YqlClient(
        server='localhost',
        port=yql_api.port,
        db='plato'
    )
    # подготовка данных для теста
    # YT_PROXY=hahn yt read-table '//home/extdata/mobile/google_play/latest/ru' --format='<format=text>yson'|grep -v NOT_FOUND |head -n 50 > ~/arc/arcadia/direct/jobs/local_yql_ut/resources/mobileappssyncjob/gplay_data.yson  # noqa
    prepare_tables(ytw, "%s/gplay_data.yson" % test_resources, gplay_table_path, gplay_ru_table)
    request = make_request("direct/jobs/src/main/resources/mobileappssync/gplay.yql",
                           "direct/jobs/src/main/resources/mobileappssync/gplay_select_part_tmpl.yql",
                           output_table_gplay,
                           input_table=(gplay_table_path, gplay_ru_table))
    run_and_compare_result(ytw, client, request,
                           '%s/gplay_expected.yson' % test_resources,
                           output_table_gplay)
