import logging
import re
import sys
import unittest

import pytest
import yql.library.fastcheck.python as fastcheck
from os import listdir, path

logger = logging.getLogger("yql_syntax_test_logger")
logger.info("=== init tests ===")

EXPORT_HOME_DIRECT_DB_PATH = 'export/home-direct-db'


def test_yql_tutorial_query():
    errors = []
    script = 'use hahn;SELECT * FROM `home/yql/tutorial/users`;'
    sys.stderr.write("\n=== debug script= " + script)
    valid = fastcheck.check_program(script, cluster_mapping={'hahn': 'yt'}, errors=errors, syntax_version=1)
    assert valid, ''.join((str(e) for e in errors))


@pytest.mark.parametrize('name', ('offlinereport', 'autooverdraft'))
def test_sql(name):
    for query_filename in listdir(name):
        if query_filename.endswith(".sql") or query_filename.endswith(".yql"):
            with open(path.join(name, query_filename), 'r') as query_file:
                script = 'use hahn; ' + query_file.read()
                script = re.sub(r"\?;--test_value=", '', script)
                sys.stderr.write("\n=== check script " + query_filename)
                errors = []
                valid = fastcheck.check_program(script, cluster_mapping={'hahn': 'yt'}, errors=errors, syntax_version=1)
                assert valid, ('filename= ' + query_filename + ' \n') + ''.join((str(e) for e in errors))

CONVERT_TO_RUB = """
$getCurrencyRate = ($code) -> {
    RETURN
        CASE $code
            WHEN 'RUB' THEN 1.0
            WHEN 'YND_FIXED' THEN 30.0
            ELSE NULL
        END
};
$countCurrencySum = ($sum, $rate) -> {
    RETURN IF($rate IS NOT NULL, Math::Round(CAST($sum AS Double) * CAST($rate AS Double), -6), NULL);
};
$convertToRub = ($sum, $code) -> {
    RETURN CAST($countCurrencySum($sum, $getCurrencyRate($code)) AS String);
};
"""


@pytest.mark.parametrize('name', (x for x in listdir(EXPORT_HOME_DIRECT_DB_PATH) if x.endswith('.yql')))
def test_export_home_direct_db_yql(name):
    query_path = path.join(EXPORT_HOME_DIRECT_DB_PATH, name)
    with open(query_path) as yql_script:
        with open(path.join(EXPORT_HOME_DIRECT_DB_PATH, 'include/common.yql')) as include_script:
            script = 'use hahn; ' + include_script.read() + CONVERT_TO_RUB + yql_script.read()
            script = script.replace('$shardsCount = ?', '$shardsCount = 21')
            script = script.replace('?', '"//home"')
            errors = []
            sys.stderr.write("\n=== check script " + query_path)
            valid = fastcheck.check_program(script, cluster_mapping={'hahn': 'yt'}, errors=errors, syntax_version=1)
            assert valid, ('filename= ' + query_path + ' \n') + ''.join((str(e) for e in errors))

if __name__ == "__main__":
    unittest.main()
