package ru.yandex.direct.autobudget.restart

import org.springframework.context.annotation.ComponentScan
import org.springframework.context.annotation.ComponentScan.Filter
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.FilterType
import org.springframework.context.annotation.Import
import ru.yandex.direct.common.configuration.CommonConfiguration

@Configuration
@Import(
    value = [
        CommonConfiguration::class
    ]
)
@ComponentScan(
    basePackages = [
        "ru.yandex.direct.autobudget.restart"
    ],
    excludeFilters = [Filter(value = [Configuration::class], type = FilterType.ANNOTATION)]
)
open class AutobudgetRestartConfiguration
