package ru.yandex.direct.autobudget.restart

import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.campaign.model.StrategyName

object StrategyUtils {
    val strategyNameMapping = StrategyName.values()
        .associateBy { StrategyName.toSource(it)?.literal }
    val platformMapping = CampaignsPlatform.values()
        .associateBy { CampaignsPlatform.toSource(it)?.literal }
    val manualStrategyMapping = CampOptionsStrategy.values()
        .associateBy { CampOptionsStrategy.toSource(it)?.literal }

    fun parseStrategyName(strategyName: String) =
        strategyNameMapping[strategyName] ?: throw IllegalArgumentException("Unknown strategy name: $strategyName")

    fun parsePlatform(platform: String) =
        platformMapping[platform] ?: throw IllegalArgumentException("Unknown platform: $platform")

    fun parseManualStrategy(manualStrategy: String) =
        manualStrategyMapping[manualStrategy] ?: throw IllegalArgumentException("Unknown platform: $manualStrategy")


}
