package ru.yandex.direct.autobudget.restart.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import java.math.BigDecimal
import java.time.LocalDate
import java.time.LocalDateTime

@JsonNaming(SnakeCaseStrategy::class)
data class StrategyDto(
    // campaigns.strategy_data.strategy_name
    val strategy: String,
    // camp_options.strategy
    val manualStrategy: String? = null,
    val platform: String? = null,

    // campaigns
    val startTime: LocalDate,
    val finishTime: LocalDate? = null,
    val dayBudget: BigDecimal? = null,
    val autoBudgetSum: BigDecimal? = null,
    val enableCpcHold: Boolean? = null,
    val timeTarget: String? = null,
    val statusShow: Boolean,

    // campaigns.strategy_data
    val payForConversion: Boolean? = null,
    val goalId: Long? = null,
    val roiCoef: BigDecimal? = null,
    val limitClicks: Long? = null,
    val avgCpm: BigDecimal? = null,
    val avgBid: BigDecimal? = null,
    val avgCpa: BigDecimal? = null,
    val avgCpv: BigDecimal? = null,
    val strategyStart: LocalDate? = null,
    val strategyFinish: LocalDate? = null,

    // calculated
    // camp_metrika_goals  WHERE links_count > 0 and find_in_set("combined",goal_role)
    val hasCombinedGoals: Boolean? = null,
    val hasMoney: Boolean? = null,
    val strategyId: Long? = null,
)

@JsonNaming(SnakeCaseStrategy::class)
data class CampStrategyRestartData(
    val cid: Long,
    val strategyDto: StrategyDto
)

/**
 * Результат рестарта
 */
sealed class CampStrategyRestartResult(
    val cid: Long
)

@JsonNaming(SnakeCaseStrategy::class)
class CampStrategyRestartResultSuccess(
    cid: Long,
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    var restartTime: LocalDateTime,
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    var softRestartTime: LocalDateTime,
    var restartReason: String
) : CampStrategyRestartResult(cid)
