package ru.yandex.direct.autobudget.restart.model

import ru.yandex.direct.autobudget.restart.service.StrategyState
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal
import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import java.math.BigDecimal
import java.time.LocalDate
import java.time.LocalDateTime

data class PackageStrategyDto(
    val hasMoney: Boolean,
    val strategyType: StrategyName,
    val isPublic: Boolean,
    val attributionModel: StrategyAttributionModel? = null,
    val sum: BigDecimal? = null,
    val meaningfulGoals: List<MeaningfulGoal>? = null,
    val bid: BigDecimal? = null,
    val isPayForConversionEnabled: Boolean? = null,
    val filterAvgCpa: BigDecimal? = null,
    val filterAvgBid: BigDecimal? = null,
    val start: LocalDate? = null,
    val finish: LocalDate? = null,
    val autoProlongation: Boolean? = null,
    val budget: BigDecimal? = null,
    val crr: Long? = null,
    val date: LocalDate? = null,
    val reserveReturn: Long? = null,
    val profitability: BigDecimal? = null,
    val roiCoef: BigDecimal? = null,
    val dayBudgetShowMode: StrategyDayBudgetShowMode? = null,
    val dayBudget: BigDecimal? = null,
    val avgCpi: BigDecimal? = null,
    val avgCpv: BigDecimal? = null,
    val avgCpa: BigDecimal? = null,
    val goalId: Long? = null,
    val avgCpm: BigDecimal? = null,
    val limitClicks: Long? = null,
    val enableCpcHold: Boolean? = null,
    val avgBid: BigDecimal? = null
)

data class PackageStrategyRestartResult(
    val strategyId: Long,
    var restartTime: LocalDateTime,
    var softRestartTime: LocalDateTime,
    var restartReason: String,
    val state: StrategyState
)
