package ru.yandex.direct.core.entity;

/**
 * StatusBsSynced доменной логики
 * Если хотим переотправить объект в БК - меняем на NO
 */
public enum StatusBsSynced {
    // объект несинхронен, его надо бы переотправить в БК
    NO,
    // объект синхронен
    YES,
    // объект несинхронен. находится в процессе отправки или отложен (не может быть отправлен сейчас)
    SENDING;

    /**
     * @return - статус в нижнем регистре, с первой буквой в верхнем (удобно для баз)
     */
    public String toDbFormat() {
        switch (this) {
            case NO:
                return "No";
            case YES:
                return "Yes";
            case SENDING:
                return "Sending";
            default:
                throw new IllegalStateException("Unknown StatusBsSynced elem");

        }
    }

    public static StatusBsSynced valueOfDbFormat(String value) {
        return StatusBsSynced.valueOf(value.toUpperCase());
    }
}
