package ru.yandex.direct.dbutil.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Пара BusinessId + ShopId
 */
@ParametersAreNonnullByDefault
public class BusinessIdAndShopId {
    private final Long businessId;
    private final Long shopId;

    private BusinessIdAndShopId(Long businessId, Long shopId) {
        this.businessId = Objects.requireNonNull(businessId, "businessId");
        this.shopId = Objects.requireNonNull(shopId, "shopId");
    }

    public static BusinessIdAndShopId of(Long businessId, Long shopId) {
        return new BusinessIdAndShopId(businessId, shopId);
    }

    @Nullable
    public static BusinessIdAndShopId ofNullable(@Nullable Long businessId, @Nullable Long shopId) {
        if (businessId == null || shopId == null) {
            return null;
        }
        return BusinessIdAndShopId.of(businessId, shopId);
    }

    public Long getBusinessId() {
        return businessId;
    }

    public Long getShopId() {
        return shopId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BusinessIdAndShopId that = (BusinessIdAndShopId) o;
        return businessId.equals(that.businessId) && shopId.equals(that.shopId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessId, shopId);
    }

    @Override
    public String toString() {
        return "BusinessIdAndShopId{" +
                "businessId=" + businessId +
                ", shopId=" + shopId +
                '}';
    }
}
