package ru.yandex.direct.dbutil.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Пара Login + ClientId
 */
@ParametersAreNonnullByDefault
public class LoginAndClientId {

    private final String login;
    private final ClientId clientId;

    private LoginAndClientId(String login, ClientId clientId) {
        this.login = Objects.requireNonNull(login, "login");
        this.clientId = Objects.requireNonNull(clientId, "clientId");
    }

    @Nonnull
    public static LoginAndClientId of(String login, ClientId clientId) {
        return new LoginAndClientId(login, clientId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LoginAndClientId that = (LoginAndClientId) o;

        return login.equals(that.login) && clientId.equals(that.clientId);
    }

    @Override
    public int hashCode() {
        int result = login.hashCode();
        result = 31 * result + clientId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "LoginAndClientId{" +
                "login=" + login +
                ", clientId=" + clientId +
                '}';
    }

    @Nonnull
    public String getLogin() {
        return login;
    }

    @Nonnull
    public ClientId getClientId() {
        return clientId;
    }
}
