package ru.yandex.direct.dbutil.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Пара Uid + ClientId пользователя
 */
@ParametersAreNonnullByDefault
public final class UidAndClientId {
    /**
     * Идентификатор пользователя в паспорте
     */
    private final Long uid;
    /**
     * Идентификатор пользователя в балансе
     */
    private final ClientId clientId;

    private UidAndClientId(Long uid, ClientId clientId) {
        this.uid = Objects.requireNonNull(uid, "uid");
        this.clientId = Objects.requireNonNull(clientId, "clientId");
    }

    @Nonnull
    public static UidAndClientId of(Long uid, ClientId clientId) {
        return new UidAndClientId(uid, clientId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UidAndClientId that = (UidAndClientId) o;

        if (!uid.equals(that.uid)) {
            return false;
        }
        return clientId.equals(that.clientId);
    }

    @Override
    public int hashCode() {
        int result = uid.hashCode();
        result = 31 * result + clientId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "UidAndClientId{" +
                "uid=" + uid +
                ", clientId=" + clientId +
                '}';
    }

    @Nonnull
    public Long getUid() {
        return uid;
    }

    @Nonnull
    public ClientId getClientId() {
        return clientId;
    }
}
