package ru.yandex.direct.dbutil.model;

import java.util.Objects;

public final class UidClientIdLogin {

    private final Long uid;
    private final ClientId clientId;
    private final String login;

    public UidClientIdLogin(Long uid, ClientId clientId, String login) {
        this.uid = uid;
        this.clientId = clientId;
        this.login = login;
    }

    public static UidClientIdLogin of(UidAndClientId uidAndClientId, String login) {
        return new UidClientIdLogin(uidAndClientId.getUid(), uidAndClientId.getClientId(), login);
    }

    public static UidClientIdLogin of(Long uid, ClientId clientId, String login) {
        return new UidClientIdLogin(uid, clientId, login);
    }

    public Long getUid() {
        return uid;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public String getLogin() {
        return login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UidClientIdLogin that = (UidClientIdLogin) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(login, that.login);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, clientId, login);
    }

    @Override
    public String toString() {
        return "UidClientIdLogin{" +
                "uid=" + uid +
                ", clientId=" + clientId +
                ", login='" + login + '\'' +
                '}';
    }
}
