package ru.yandex.direct.feature;

public enum FeatureType {

    /**
     * Фича, которую можно выдать только по clientId (а на роль и процент нельзя).
     * Такие фичи являются постоянными, позволяют открывать функциональность только определённым клиентам.
     */
    PERMANENT,

    /**
     * Фича, которую можно выдать всеми способами - по clientId, на роль, на процент.
     * Выдача на процент подразумевает постепенную раскатку до 100%, после чего фича подлежит удалению, поэтому
     * такая фича является временной.
     */
    TEMP

}
