package ru.yandex.direct.rbac;

import ru.yandex.direct.dbschema.ppc.enums.UsersAgencyLimRepType;

public enum RbacAgencyLimRepType {
    LEGACY,
    CHIEF,
    MAIN;

    public static RbacAgencyLimRepType fromSource(UsersAgencyLimRepType dbRepType) {
        if (dbRepType == null) {
            return LEGACY;
        }
        switch (dbRepType) {
            case chief:
                return CHIEF;
            case main:
                return MAIN;
            default:
                throw new IllegalArgumentException("Unknown reptype: " + dbRepType);
        }
    }

    public static UsersAgencyLimRepType toSource(RbacAgencyLimRepType repType) {
        if (repType == null) {
            return null;
        }
        switch (repType) {
            case CHIEF:
                return UsersAgencyLimRepType.chief;
            case MAIN:
                return UsersAgencyLimRepType.main;
            case LEGACY:
                return null;
            default:
                throw new IllegalArgumentException("Unknown reptype: " + repType);
        }
    }
}
