package ru.yandex.direct.rbac;

import ru.yandex.direct.dbschema.ppc.enums.UsersRepType;

public enum RbacRepType {
    CHIEF,
    MAIN,
    LIMITED,
    READONLY;

    public static RbacRepType fromSource(UsersRepType dbRepType) {
        if (dbRepType == null) {
            return null;
        }
        switch (dbRepType) {
            case chief:
                return CHIEF;
            case main:
                return MAIN;
            case limited:
                return LIMITED;
            case readonly:
                return READONLY;
            default:
                throw new IllegalArgumentException("Unknown reptype: " + dbRepType);
        }
    }

    public static UsersRepType toSource(RbacRepType repType) {
        if (repType == null) {
            return null;
        }
        switch (repType) {
            case CHIEF:
                return UsersRepType.chief;
            case MAIN:
                return UsersRepType.main;
            case LIMITED:
                return UsersRepType.limited;
            case READONLY:
                return UsersRepType.readonly;
            default:
                throw new IllegalArgumentException("Unknown reptype: " + repType);
        }
    }
}
