package ru.yandex.direct.rbac;

import javax.annotation.Nullable;

import ru.yandex.direct.dbschema.ppc.enums.ClientsSubrole;

public enum RbacSubrole {
    SUPERTEAMLEADER,

    TEAMLEADER,

    SUPERPLACER,

    SUPERMEDIA;

    @Nullable
    public static RbacSubrole fromSource(ClientsSubrole value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case superteamleader:
                return SUPERTEAMLEADER;
            case teamleader:
                return TEAMLEADER;
            case superplacer:
                return SUPERPLACER;
            case supermedia:
                return SUPERMEDIA;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static ClientsSubrole toSource(RbacSubrole value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case SUPERTEAMLEADER:
                return ClientsSubrole.superteamleader;
            case TEAMLEADER:
                return ClientsSubrole.teamleader;
            case SUPERPLACER:
                return ClientsSubrole.superplacer;
            case SUPERMEDIA:
                return ClientsSubrole.supermedia;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
