package ru.yandex.direct.bmapi.api

import ru.yandex.direct.bmapi.client.model.BmApiFeedInfoResponse
import ru.yandex.direct.http.smart.annotations.Id
import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.http.GET
import ru.yandex.direct.http.smart.http.Headers
import ru.yandex.direct.http.smart.http.Query

interface BmApi {
    @GET("/")
    @Json
    @Headers("Content-Type: application/json")
    fun call(
        @Id feedIdAsRequestId: Long?, // ? чтобы в Java был Long, а не long
        @Query("cmd") cmd: String,
        @Query("url") url: String,
        @Query("business_type") businessType: String,
        @Query("last_valid_feed_type") lastValidFeedType: String?,
        @Query("max_file_size") maxFileSize: Long,
        @Query("max_file_size_type") maxFileSizeType: String,
        @Query("status") updateStatus: String?,
        @Query("feed_id") feedId: Long,
        @Query("with_previews") withPreviews: Int,
        @Query("login") login: String?,
        @Query("pass") password: String?,
    ): Call<BmApiFeedInfoResponse>
}
