package ru.yandex.direct.bmapi.client.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

enum class BmApiErrorCode(@JsonValue val code: Int) {
    BL_ERROR_FETCH_FAILED(1201),
    BL_ERROR_YML_NO_MODEL_OR_TAG_NAME(1203),
    BL_ERROR_XML_FATAL(1204),
    BL_ERROR_XML_NO_OFFERS(1205),
    BL_ERROR_XML_NO_CATEGORIES(1206),
    BL_ERROR_YML_NO_URL_TAG(1207),
    BL_ERROR_EMPTY_FILE(1211),
    BL_ERROR_FEED_TYPE_MISMATCH(1212),
    BL_ERROR_FEED_DATA_TYPE_MISMATCH(1213),
    BL_ERROR_BUSINESS_TYPE_MISMATCH(1220),
    BL_ERROR_FILE_TOO_BIG(1266),
    BL_ERROR_CATEGORY_NOT_POSITIVE_INTEGER(1290),
    BL_ERROR_FATAL(1812),

    //ClientID агентства yndx-smart-recommend-agency (DIRECT-123740)
    YNDX_SMART_RECOMMEND_AGENCY_CLIENT_ID(74171260);

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromStringRepresentation(code: String): BmApiErrorCode =
            values().firstOrNull { it.code == code.toInt() } ?: BL_ERROR_FATAL

        const val FEED_TYPE_ERROR_MESSAGE = "Er1212: Incorrect feed type or invalid feed type change"
    }
}
