package ru.yandex.direct.bmapi.client.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.core.entity.feed.model.FeedOfferExamples

@JsonIgnoreProperties(ignoreUnknown = true)
data class BmApiFeedInfoResponse(
    @JsonProperty("categoryId")
    val categoryIdsToOffersCount: Map<String, Int>?,
    @JsonProperty("warnings")
    val warnings: List<BmApiWarning>?,
    @JsonProperty("errors")
    val errors: List<BmApiError>?,
    @JsonProperty("feed_type")
    val feedType: String?,
    @JsonProperty("all_elements_amount")
    val totalOffersAmount: Long?,
    @JsonProperty("domain")
    var domain: Map<String, Int>?,
    @JsonProperty("categs")
    val categories: List<Category>?,
    @JsonProperty("vendor")
    val vendorsToOffersCount: Map<String, Int>?,
    @JsonProperty("offer_examples")
    val feedOfferExamples: FeedOfferExamples?
)

@JsonIgnoreProperties(ignoreUnknown = true)
data class Category(
    @JsonProperty("id")
    val id: String,
    @JsonProperty("parentId")
    val parentId: String?,
    @JsonProperty("category")
    val name: String
)

@JsonIgnoreProperties(ignoreUnknown = true)
data class BmApiWarning(
    @JsonProperty("code")
    val code: Int,
    @JsonProperty("message")
    val messageEn: String,
    @JsonProperty("message_ru")
    val messageRu: String?
)

@JsonIgnoreProperties(ignoreUnknown = true)
data class BmApiError(
    @JsonProperty("code")
    val error: BmApiErrorCode,
    @JsonProperty("message")
    val messageEn: String,
    @JsonProperty("message_ru")
    val messageRu: String?
)
