package ru.yandex.direct.bs.dspcreative.component;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.bs.dspcreative.model.DspCreativeConverterType;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;

@Component
@ParametersAreNonnullByDefault
public class DspCreativeBannerstorageConverter extends DspCreativeBaseConverter {
    public DspCreativeBannerstorageConverter(DspCreativeUtils dspCreativeUtils) {
        super(dspCreativeUtils);
    }

    @Override
    DspCreativeConverterType getConverterType() {
        return DspCreativeConverterType.BANNER_STORAGE;
    }

    @Override
    void checkCustomRequiredFields(DspCreativeExportEntry dspCreativeEntry) {
        Preconditions.checkNotNull(dspCreativeEntry.getCreativeTemplateId(), "CreativeTemplateId is required");
        Preconditions.checkNotNull(dspCreativeEntry.getTnsBrand(), "TnsBrand is required");
        Preconditions.checkNotNull(dspCreativeEntry.getTnsArticle(), "TnsArticle is required");
        Preconditions.checkNotNull(dspCreativeEntry.getGeo(), "Geo is required");
        Preconditions.checkNotNull(dspCreativeEntry.getSite(), "Site is required");
        Preconditions.checkNotNull(dspCreativeEntry.getParameterValues(), "ParamValues is required");
        Preconditions.checkNotNull(dspCreativeEntry.getCreativeCodeId(), "CreativeCodeId is required");
    }

    @Override
    String defaultStaticData(DspCreativeExportEntry dspCreativeExportEntry) {
        return dspCreativeExportEntry.getStaticData();
    }
}
