package ru.yandex.direct.bs.dspcreative.component;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.bs.dspcreative.model.DspCreativeConverterType;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;

@Component
@ParametersAreNonnullByDefault
public class DspCreativeCanvasConverter extends DspCreativeBaseConverter {
    public DspCreativeCanvasConverter(DspCreativeUtils dspCreativeUtils) {
        super(dspCreativeUtils);
    }

    @Override
    DspCreativeConverterType getConverterType() {
        return DspCreativeConverterType.CANVAS;
    }

    @Override
    void checkCustomRequiredFields(DspCreativeExportEntry dspCreativeEntry) {
        Preconditions.checkNotNull(dspCreativeEntry.getConstructorData(), "ConstructorData is required");
    }

    @Override
    String defaultStaticData(DspCreativeExportEntry dspCreativeExportEntry) {
        String staticData = dspCreativeExportEntry.getStaticData();
        if (staticData == null || staticData.isEmpty()) {
            return String.format("{\"creative_id\": \"%d\"}", dspCreativeExportEntry.getCreativeId());
        }
        return staticData;
    }
}
