package ru.yandex.direct.bs.dspcreative.component;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bs.dspcreative.model.DspCreativeConverterType;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;

import static java.util.stream.Collectors.toMap;

@Component
@ParametersAreNonnullByDefault
public class DspCreativeConverterProvider {
    private final Map<DspCreativeConverterType, DspCreativeBaseConverter> dspCreativesConvertersMap;

    public DspCreativeConverterProvider(List<DspCreativeBaseConverter> dspCreativeYtExporters) {
        this.dspCreativesConvertersMap = dspCreativeYtExporters
                .stream()
                .collect(toMap(DspCreativeBaseConverter::getConverterType, converter -> converter));
    }

    /*
    Получаем конвертер для соответствующей записи
     */
    public DspCreativeBaseConverter get(DspCreativeExportEntry entry) {
        DspCreativeConverterType converterType = determineDspCreativeConverterType(entry);
        return dspCreativesConvertersMap.get(converterType);
    }

    /*
    Определяем тип конвертера для соответствующей записи
     */
    private DspCreativeConverterType determineDspCreativeConverterType(DspCreativeExportEntry entry) {
        if (entry.getConstructorData() != null) {
            return DspCreativeConverterType.CANVAS;
        }
        return DspCreativeConverterType.BANNER_STORAGE;
    }
}
