package ru.yandex.direct.bs.dspcreative.component;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.solomon.SolomonPushClient;
import ru.yandex.direct.solomon.SolomonPushClientException;
import ru.yandex.direct.solomon.SolomonUtils;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Component
@ParametersAreNonnullByDefault
public class DspCreativeMetricsReporter {
    private static final Logger logger = LoggerFactory.getLogger(DspCreativeMetricsReporter.class);

    private static final String CREATIVE_SUCCESSES_COUNT_METRIC_NAME = "export_creative_successes_count";
    private static final String CREATIVE_FAILS_COUNT_METRIC_NAME = "export_creative_fails_count";

    private final SolomonPushClient solomonPushClient;

    public DspCreativeMetricsReporter(SolomonPushClient solomonPushClient) {
        this.solomonPushClient = solomonPushClient;
    }

    /*
     * Пишем:
     * 1. сколько креативов были успешно выгружены в YT
     * 2. сколько креативов не удалось выгрузить в YT
     */
    public void report(int successesCount, int failsCount) {
        MetricRegistry metricsRegistry = SolomonUtils.newPushRegistry("flow", "dsp_creative_export");
        metricsRegistry.gaugeInt64(CREATIVE_SUCCESSES_COUNT_METRIC_NAME).set(successesCount);
        metricsRegistry.gaugeInt64(CREATIVE_FAILS_COUNT_METRIC_NAME).set(failsCount);

        try {
            solomonPushClient.sendMetrics(metricsRegistry);
        } catch (SolomonPushClientException e) {
            logger.error("Can't send metrics for DspCreative export", e);
        }
    }
}
