package ru.yandex.direct.bs.dspcreative.component;

import java.time.Clock;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bs.id.generator.BsDomainIdGeneratorClient;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
public class DspCreativeUtils {
    private final ShardHelper shardHelper;
    private final BsDomainIdGeneratorClient bsDomainIdGeneratorClient;
    private final Clock clock;

    public DspCreativeUtils(ShardHelper shardHelper, BsDomainIdGeneratorClient bsDomainIdGeneratorClient) {
        this.shardHelper = shardHelper;
        this.bsDomainIdGeneratorClient = bsDomainIdGeneratorClient;
        this.clock = Clock.systemUTC();
    }

    public long getCurrentTimestamp() {
        return clock.instant().getEpochSecond();
    }

    /**
     * Конвертация аналогичная ручке bssoap
     */
    public long convertDateToTimestamp(@Nullable Date date) {
        if (date == null) {
            return 0L;
        }

        return date.toInstant()
                .atZone(ZoneId.of("UTC"))
                .toLocalDateTime()
                .atZone(ZoneId.of("Europe/Moscow"))
                .toEpochSecond();
    }

    public long generateDspCreativeIterId() {
        return shardHelper.generateDspCreativeCaesarIterId(1).get(0);
    }

    /*
    Отправляем домены в БК
     */
    public void addDomainListToTargetDomain(List<String> domainList) {
        List<String> domainListUniq = domainList
                .stream()
                .map(domain -> domain.toLowerCase().strip())
                .filter(domain -> !domain.isEmpty())
                .distinct()
                .collect(Collectors.toList());

        if (domainList.isEmpty()) {
            return;
        }
        bsDomainIdGeneratorClient.generate(domainListUniq);
    }
}
