package ru.yandex.direct.bs.dspcreative.configuration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.bstransport.yt.configuration.BsTransportYtConfiguration;
import ru.yandex.direct.integrations.configuration.IntegrationsConfiguration;
import ru.yandex.direct.ytcomponents.spring.YtComponentsConfiguration;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.bs.dspcreative",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        BsTransportYtConfiguration.class,
        YtComponentsConfiguration.class,
        IntegrationsConfiguration.class
})
@ParametersAreNonnullByDefault
public class BsDspCreativeConfiguration {
}

