package ru.yandex.direct.bs.dspcreative.model;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/*
 * Данные креатива, которые отправляются в ручку БК import-dsp-creative с целью последующей выгрузки в YT.
 * https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-export/cgi/import-dsp-creative.cgi?rev=7527674
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public final class DspCreativeExportEntry {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @JsonProperty("CreativeId")
    private Long creativeId;

    @JsonProperty("CreativeVersionId")
    private Long creativeVersionId;

    @JsonProperty("TemplateId")
    private Long creativeTemplateId;

    @JsonProperty("CodeId")
    private Long creativeCodeId;

    @JsonProperty("CreateTime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DATE_FORMAT)
    private Date createTime;

    @JsonProperty("ExpireTime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DATE_FORMAT)
    private Date expireTime;

    @JsonProperty("TNSBrand")
    private List<Long> tnsBrand;

    @JsonProperty("TNSArticle")
    private List<Long> tnsArticle;

    @JsonProperty("Geo")
    private List<Long> geo;

    @JsonProperty("Site")
    private List<Long> site;

    @JsonProperty("DomainList")
    private List<String> domainList;

    @JsonProperty("Data")
    private String data;

    @JsonProperty("StaticData")
    private String staticData;

    @JsonProperty("ConstructorData")
    private String constructorData;

    @JsonProperty("IsEnabled")
    private Boolean isEnabled;

    @JsonProperty("IsVideo")
    private Boolean isVideo;

    @JsonProperty("IsAudio")
    private Boolean isAudio;

    @JsonProperty("IsStatic")
    private Boolean isStatic;

    @JsonProperty("PostmoderatedObjects")
    private Boolean postmoderated;

    @JsonProperty("Tag")
    private String tag;

    @JsonProperty("DspId")
    private Long dspId;

    @JsonProperty("Width")
    private Integer width;

    @JsonProperty("Height")
    private Integer height;

    @JsonProperty("FirstShowItems")
    private Long firstShowItems;

    @JsonProperty("MinShowItems")
    private Long minShowItems;

    @JsonProperty("MaxShowItems")
    private Long maxShowItems;

    @JsonProperty("IsAdaptive")
    private Boolean isAdaptive = false;

    @JsonProperty("IsGeoPin")
    private Boolean isGeoPin = false;

    @JsonProperty("Token")
    private String token;

    @JsonProperty("ParamValues")
    private List<DspCreativeParameterValue> parameterValues = Collections.emptyList();

    @JsonProperty("SmartThemeId")
    private Long smartThemeId;

    @JsonProperty("SmartLayoutId")
    private Long smartLayoutId;

    @JsonProperty("SmartSizeId")
    private Long smartSizeId;

    @Override
    public String toString() {
        return "DspCreativeExportEntry{" +
                "creativeId=" + creativeId +
                ", creativeVersionId=" + creativeVersionId +
                ", createTime=" + createTime +
                ", expireTime=" + expireTime +
                ", data='" + data + '\'' +
                ", staticData='" + staticData + '\'' +
                ", constructorData='" + constructorData + '\'' +
                ", isEnabled=" + isEnabled +
                ", isVideo=" + isVideo +
                ", isAudio=" + isAudio +
                ", isStatic=" + isStatic +
                ", postmoderated=" + postmoderated +
                ", tag='" + tag + '\'' +
                ", width=" + width +
                ", height=" + height +
                ", isAdaptive=" + isAdaptive +
                ", isGeoPin=" + isGeoPin +
                '}';
    }

    private DspCreativeExportEntry() {
    }

    private DspCreativeExportEntry(Long creativeId, Long creativeVersionId, Long creativeTemplateId, Long creativeCodeId,
                                   Date createTime, Date expireTime, List<Long> tnsBrand, List<Long> tnsArticle,
                                   List<Long> geo, List<Long> site, List<String> domainList, String data, String staticData,
                                   String constructorData, Boolean isEnabled, Boolean isVideo, Boolean isAudio,
                                   Boolean isStatic, Boolean postmoderated, String tag, Long dspId, Integer width,
                                   Integer height, Long firstShowItems, Long maxShowItems, Long minShowItems,
                                   Boolean isAdaptive, Boolean isGeoPin, String token, List<DspCreativeParameterValue> parameterValues,
                                   Long smartThemeId, Long smartLayoutId, Long smartSizeId) {
        this.creativeId = creativeId;
        this.creativeVersionId = creativeVersionId;
        this.creativeTemplateId = creativeTemplateId;
        this.creativeCodeId = creativeCodeId;
        this.createTime = createTime;
        this.expireTime = expireTime;
        this.tnsBrand = tnsBrand;
        this.tnsArticle = tnsArticle;
        this.geo = geo;
        this.site = site;
        this.domainList = domainList;
        this.data = data;
        this.staticData = staticData;
        this.constructorData = constructorData;
        this.isEnabled = isEnabled;
        this.isVideo = isVideo;
        this.isAudio = isAudio;
        this.isStatic = isStatic;
        this.postmoderated = postmoderated;
        this.tag = tag;
        this.dspId = dspId;
        this.width = width;
        this.height = height;
        this.firstShowItems = firstShowItems;
        this.maxShowItems = maxShowItems;
        this.minShowItems = minShowItems;
        this.isAdaptive = isAdaptive;
        this.isGeoPin = isGeoPin;
        this.token = token;
        this.parameterValues = parameterValues;
        this.smartThemeId = smartThemeId;
        this.smartLayoutId = smartLayoutId;
        this.smartSizeId = smartSizeId;
    }

    public static Builder builder() {
        return new DspCreativeExportEntry().new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder setCreativeId(Long creativeId) {
            DspCreativeExportEntry.this.creativeId = creativeId;
            return this;
        }

        public Builder setCreativeVersionId(Long creativeVersionId) {
            DspCreativeExportEntry.this.creativeVersionId = creativeVersionId;
            return this;
        }

        public Builder setCreativeTemplateId(Long creativeTemplateId) {
            DspCreativeExportEntry.this.creativeTemplateId = creativeTemplateId;
            return this;
        }

        public Builder setCreativeCodeId(Long creativeCodeId) {
            DspCreativeExportEntry.this.creativeCodeId = creativeCodeId;
            return this;
        }

        public Builder setCreateTime(Date createTime) {
            DspCreativeExportEntry.this.createTime = createTime;
            return this;
        }

        public Builder setExpireTime(Date expireTime) {
            DspCreativeExportEntry.this.expireTime = expireTime;
            return this;
        }

        public Builder setTnsBrand(List<Long> tnsBrand) {
            DspCreativeExportEntry.this.tnsBrand = tnsBrand;
            return this;
        }

        public Builder setTnsArticle(List<Long> tnsArticle) {
            DspCreativeExportEntry.this.tnsArticle = tnsArticle;
            return this;
        }

        public Builder setGeo(List<Long> geo) {
            DspCreativeExportEntry.this.geo = geo;
            return this;
        }

        public Builder setSite(List<Long> site) {
            DspCreativeExportEntry.this.site = site;
            return this;
        }

        public Builder setDomainList(List<String> domainList) {
            DspCreativeExportEntry.this.domainList = domainList;
            return this;
        }

        public Builder setData(String data) {
            DspCreativeExportEntry.this.data = data;
            return this;
        }

        public Builder setStaticData(String staticData) {
            DspCreativeExportEntry.this.staticData = staticData;
            return this;
        }

        public Builder setConstructorData(String constructorData) {
            DspCreativeExportEntry.this.constructorData = constructorData;
            return this;
        }

        public Builder setEnabled(Boolean enabled) {
            DspCreativeExportEntry.this.isEnabled = enabled;
            return this;
        }

        public Builder setVideo(Boolean video) {
            DspCreativeExportEntry.this.isVideo = video;
            return this;
        }

        public Builder setAudio(Boolean audio) {
            DspCreativeExportEntry.this.isAudio = audio;
            return this;
        }

        public Builder setStatic(Boolean aStatic) {
            isStatic = aStatic;
            return this;
        }

        public Builder setPostmoderated(Boolean postmoderated) {
            DspCreativeExportEntry.this.postmoderated = postmoderated;
            return this;
        }

        public Builder setTag(String tag) {
            DspCreativeExportEntry.this.tag = tag;
            return this;
        }

        public Builder setDspId(Long dspId) {
            DspCreativeExportEntry.this.dspId = dspId;
            return this;
        }

        public Builder setWidth(Integer width) {
            DspCreativeExportEntry.this.width = width;
            return this;
        }

        public Builder setHeight(Integer height) {
            DspCreativeExportEntry.this.height = height;
            return this;
        }

        public Builder setFirstShowItems(Long firstShowItems) {
            DspCreativeExportEntry.this.firstShowItems = firstShowItems;
            return this;
        }

        public Builder setMaxShowItems(Long maxShowItems) {
            DspCreativeExportEntry.this.maxShowItems = maxShowItems;
            return this;
        }

        public Builder setMinShowItems(Long minShowItems) {
            DspCreativeExportEntry.this.minShowItems = minShowItems;
            return this;
        }

        public Builder setIsAdaptive(Boolean isAdaptive) {
            DspCreativeExportEntry.this.isAdaptive = isAdaptive;
            return this;
        }

        public Builder setIsGeoPin(Boolean isGeoPin) {
            DspCreativeExportEntry.this.isGeoPin = isGeoPin;
            return this;
        }

        public Builder setToken(String token) {
            DspCreativeExportEntry.this.token = token;
            return this;
        }

        public Builder setParameterValues(List<DspCreativeParameterValue> parameterValues) {
            DspCreativeExportEntry.this.parameterValues = parameterValues;
            return this;
        }

        public Builder setSmartThemeId(Long smartThemeId) {
            DspCreativeExportEntry.this.smartThemeId = smartThemeId;
            return this;
        }

        public Builder setSmartLayoutId(Long smartLayoutId) {
            DspCreativeExportEntry.this.smartLayoutId = smartLayoutId;
            return this;
        }

        public Builder setSmartSizeId(Long smartSizeId) {
            DspCreativeExportEntry.this.smartSizeId = smartSizeId;
            return this;
        }

        public DspCreativeExportEntry build() {
            return new DspCreativeExportEntry(creativeId, creativeVersionId, creativeTemplateId, creativeCodeId,
                    createTime, expireTime, tnsBrand, tnsArticle, geo, site, domainList, data, staticData,
                    constructorData, isEnabled, isVideo, isAudio, isStatic, postmoderated, tag, dspId, width, height,
                    firstShowItems, maxShowItems, minShowItems, isAdaptive, isGeoPin, token, parameterValues,
                    smartThemeId, smartLayoutId, smartSizeId);
        }
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public Long getCreativeVersionId() {
        return creativeVersionId;
    }

    public Long getCreativeTemplateId() {
        return creativeTemplateId;
    }

    public Long getCreativeCodeId() {
        return creativeCodeId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public List<Long> getTnsBrand() {
        return tnsBrand;
    }

    public List<Long> getTnsArticle() {
        return tnsArticle;
    }

    public List<Long> getGeo() {
        return geo;
    }

    public List<Long> getSite() {
        return site;
    }

    public List<String> getDomainList() {
        return domainList;
    }

    public String getData() {
        return data;
    }

    public String getConstructorData() {
        return constructorData;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public Boolean getIsVideo() {
        return isVideo;
    }

    public Boolean getIsAudio() {
        return isAudio;
    }

    public Boolean getIsStatic() {
        return isStatic;
    }

    public Boolean getPostmoderated() {
        return postmoderated;
    }

    public String getTag() {
        return tag;
    }

    public Long getDspId() {
        return dspId;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    public Long getFirstShowItems() {
        return firstShowItems;
    }

    public Long getMaxShowItems() {
        return maxShowItems;
    }

    public Long getMinShowItems() {
        return minShowItems;
    }

    public String getStaticData() {
        return staticData;
    }

    public Boolean getIsAdaptive() {
        return isAdaptive;
    }

    public Boolean getIsGeoPin() {
        return isGeoPin;
    }

    public String getToken() {
        return token;
    }

    public List<DspCreativeParameterValue> getParameterValues() {
        return parameterValues;
    }

    public Long getSmartThemeId() {
        return smartThemeId;
    }

    public Long getSmartSizeId() {
        return smartSizeId;
    }

    public Long getSmartLayoutId() {
        return smartLayoutId;
    }
}
