package ru.yandex.direct.bs.dspcreative.model;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Значение параметра креатива.
 * !!! То же самое, что и
 * https://github.yandex-team.ru/MediaSelling/bannerstorage-harvester/blob/9828c24b3e43c607779ed3f5fa1b53947a859fc5/bannerstorage-harvester/src/main/java/ru/yandex/bannerstorage/harvester/queues/rtbintegration/creativechanged/models/ParameterValue.java
 * После переезда bannerstorage в аркадию оставить только один
 *
 */
public final class DspCreativeParameterValue {
    @JsonProperty("ParamName")
    private final String paramName;
    @JsonProperty("ParamType")
    private final String paramType;
    @JsonProperty("ParamValue")
    private final List<String> paramValues;
    @JsonIgnore
    private final Integer orderInList;

    public DspCreativeParameterValue(
            String paramName, List<String> paramValues, Integer orderInList, String paramType) {
        this.paramName = paramName;
        this.paramType = paramType;
        this.paramValues = paramValues != null ? paramValues : Collections.emptyList();
        this.orderInList = orderInList;
    }

    @Override
    public String toString() {
        return "DspCreativeParameterValue{" +
                "paramName='" + paramName + '\'' +
                ", paramType='" + paramType + '\'' +
                ", paramValues=" + paramValues +
                ", orderInList=" + orderInList +
                '}';
    }

    public String getParamName() {
        return paramName;
    }

    public String getParamType() {
        return paramType;
    }

    public List<String> getParamValues() {
        return paramValues;
    }

    public Integer getOrderInList() {
        return orderInList;
    }
}
