package ru.yandex.direct.bs.dspcreative.service;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.adv.direct.dspcreative.TDspCreative;
import ru.yandex.direct.bs.dspcreative.component.DspCreativeConverterProvider;
import ru.yandex.direct.bs.dspcreative.component.DspCreativeMetricsReporter;
import ru.yandex.direct.bs.dspcreative.exception.DspCreativeExportException;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;
import ru.yandex.direct.bstransport.yt.repository.dspcreative.DspCreativeYtRepository;

@Service
@ParametersAreNonnullByDefault
public class DspCreativeYtExporter {
    private static final Logger logger = LoggerFactory.getLogger(DspCreativeYtExporter.class);

    private final DspCreativeYtRepository dspCreativeYtRepository;
    private final DspCreativeConverterProvider dspCreativeConverterProvider;
    private final DspCreativeMetricsReporter dspCreativeMetricsReporter;

    public DspCreativeYtExporter(DspCreativeYtRepository dspCreativeYtRepository,
                                 DspCreativeConverterProvider dspCreativeConverterProvider,
                                 DspCreativeMetricsReporter dspCreativeMetricsReporter) {
        this.dspCreativeYtRepository = dspCreativeYtRepository;
        this.dspCreativeConverterProvider = dspCreativeConverterProvider;
        this.dspCreativeMetricsReporter = dspCreativeMetricsReporter;
    }

    public void export(List<DspCreativeExportEntry> entries) {
        try {
            logger.info("Converting entries to DspCreative objects");
            List<TDspCreative> dspCreatives = entries
                    .stream()
                    .map(entry -> dspCreativeConverterProvider.get(entry).convert(entry))
                    .collect(Collectors.toList());

            logger.info("Start exporting to DspCreative table and queue on YT");
            dspCreativeYtRepository.modify(dspCreatives);

            logger.info("DspCreative export finished successfully");
            dspCreativeMetricsReporter.report(entries.size(), 0);
        } catch (Exception e) {
            dspCreativeMetricsReporter.report(0, entries.size());
            throw new DspCreativeExportException("DspCreative export failed", e);
        }
    }
}
