package ru.yandex.direct.bs.id.generator;

import java.time.Duration;
import java.util.Objects;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;

public class BsDomainIdGeneratorClientConfig {

    private final String url;
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final int requestRetries;
    private final int tvmId;

    private BsDomainIdGeneratorClientConfig(
            String url, Duration connectTimeout, Duration requestTimeout, int requestRetries, int tvmId) {
        this.url = url;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.requestRetries = requestRetries;
        this.tvmId = tvmId;
    }

    @Nonnull
    public String getUrl() {
        return url;
    }

    @Nonnull
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    @Nonnull
    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    @Nonnull
    public int getRequestRetries() {
        return requestRetries;
    }

    @Nonnull
    public int getTvmId() {
        return tvmId;
    }

    public static class Builder {
        private String url;
        private Duration connectTimeout;
        private Duration requestTimeout;
        private Integer requestRetries;
        private Integer tvmId;

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder withRequestRetries(int requestRetries) {
            this.requestRetries = requestRetries;
            return this;
        }

        public Builder withTvmId(int tvmId) {
            this.tvmId = tvmId;
            return this;
        }

        public BsDomainIdGeneratorClientConfig build() {
            checkArgument(Objects.nonNull(url));
            checkArgument(Objects.nonNull(connectTimeout));
            checkArgument(Objects.nonNull(requestTimeout));
            checkArgument(Objects.nonNull(requestRetries));
            checkArgument(Objects.nonNull(tvmId));
            return new BsDomainIdGeneratorClientConfig(url, connectTimeout, requestTimeout, requestRetries, tvmId);
        }
    }
}
