#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import cStringIO as io
import logging
import os
import sys
import time

from yt import yson
from yt.wrapper import YtClient


def yt_reshard_table(ytc, table, tablets, hash_modulo):
    pivot_keys = [[]]
    min_val = 0
    max_val = hash_modulo

    delta = max_val - min_val
    for i in xrange(1, tablets):
        val = min_val + (i * delta) // tablets
        val = yson.YsonUint64(val)
        pivot_keys.append([val])

    ytc.reshard_table(table, pivot_keys)

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '--proxy',
        default=os.environ.get('YT_PROXY'),
        help="yt url (default: YT_PROXY environment variable)",
    )
    parser.add_argument(
        '--token',
        default=os.environ.get('YT_TOKEN'),
        help="yt token (default: YT_TOKEN environment variable)",
    )
    parser.add_argument(
        '--table',
        help="yt table path",
    )
    parser.add_argument(
        '--tablets',
        type=int,
        help="table tablets count",
    )
    parser.add_argument(
        '--hash-modulo', 
        type=int,
        help="Hash module in YtHash expression",
    )

    return parser.parse_args()

def main(args):
    ytc = YtClient(proxy=args.proxy, token=args.token)
    if sys.platform == 'darwin':
        ytc.config['pickling']['module_filter'] = lambda module: hasattr(module, '__file__') and \
            not module.__file__.endswith('.so') and 'hashlib' not in getattr(module, '__name__', '')

    logging.info('Start reshard table!')
    yt_reshard_table(ytc, args.table, args.tablets, args.hash_modulo)
    logging.info('Resharded!')

if __name__ == '__main__':
    logging.basicConfig(format='%(asctime)s - %(message)s', level=logging.INFO)
    main(parse_args())
