package ru.yandex.direct.bstransport.yt.repository;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.BsExportYtDynConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;

@Component
public class BsExportYtRepositoryContext {
    private final YtProvider ytProvider;
    private final BsExportYtDynConfig ytConfig;
    private final CaesarQueueRequestFactory caesarQueueRequestFactory;

    public BsExportYtRepositoryContext(YtProvider ytProvider, BsExportYtDynConfig ytConfig,
                                       CaesarQueueRequestFactory caesarQueueRequestFactory) {
        this.ytProvider = ytProvider;
        this.ytConfig = ytConfig;
        this.caesarQueueRequestFactory = caesarQueueRequestFactory;
    }

    public YtProvider getYtProvider() {
        return ytProvider;
    }

    public BsExportYtDynConfig getYtConfig() {
        return ytConfig;
    }

    public CaesarQueueRequestFactory getCaesarQueueWriter() {
        return caesarQueueRequestFactory;
    }
}
