package ru.yandex.direct.bstransport.yt.repository;

import java.util.List;

import com.google.protobuf.Message;
import org.springframework.stereotype.Component;

import ru.yandex.direct.bstransport.yt.utils.ProtoSeqSerializer;
import ru.yandex.direct.ytcomponents.config.BsExportYtDynConfig;
import ru.yandex.yt.ytclient.proxy.ModifyRowsRequest;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;

@Component
public class CaesarQueueRequestFactory {
    private final ProtoSeqSerializer protoSeqSerializer;
    private final TableSchema queueSchema;

    public CaesarQueueRequestFactory(BsExportYtDynConfig config) {
        var batchSize = config.getQueueBatchSize();
        var batchSizeKilobytes = config.getQueueBatchSizeKilobytes();
        this.protoSeqSerializer = new ProtoSeqSerializer(batchSize, batchSizeKilobytes);
        this.queueSchema = new TableSchema.Builder()
                .addValue("value", ColumnValueType.STRING)
                .setUniqueKeys(false)
                .build();
    }

    public <T extends Message> ModifyRowsRequest getRequest(List<T> rows, String queuePath) {
        ModifyRowsRequest queueRequest = new ModifyRowsRequest(queuePath, queueSchema);
        for (var protoSeq : protoSeqSerializer.serialize(rows)) {
            queueRequest.addInsert(List.of(protoSeq));
        }
        return queueRequest;
    }
}
