package ru.yandex.direct.bstransport.yt.repository

import ru.yandex.yt.ytclient.tables.ColumnSchema
import ru.yandex.yt.ytclient.tables.ColumnValueType

/**
 * Маппинг полей таблицы в yt в функции, вычисляющие значения для этого поля
 * Схему таблицы нужно указывать с ключами
 *
 * @param <T> объект, из которого будут вычисляться значения полей
</T> */
open class ColumnMapping<T>(open val columnDescription: ColumnDescription<*>, val fromProtoToYtMapper: (T) -> Any?) {
    constructor(columnSchema: ColumnSchema, mapping: (T) -> Any?) :
        this(when (columnSchema.type) {
            ColumnValueType.INT64 -> int64Column(columnSchema.name, columnSchema.sortOrder)
            ColumnValueType.UINT64 -> uint64Column(columnSchema.name, columnSchema.sortOrder)
            ColumnValueType.STRING -> stringColumn(columnSchema.name, columnSchema.sortOrder)
            ColumnValueType.DOUBLE -> doubleColumn(columnSchema.name, columnSchema.sortOrder)
            ColumnValueType.BOOLEAN -> boolColumn(columnSchema.name, columnSchema.sortOrder)
            ColumnValueType.ANY -> customColumn(columnSchema.name, columnSchema.sortOrder)
            else -> throw IllegalStateException("Unsupported type ${columnSchema.type}")
        }, mapping)


    val name: String
        get() = columnDescription.name

    val type: ColumnValueType
        get() = columnDescription.type


    val columnSchema: ColumnSchema
        get() = columnDescription.columnSchema

    fun extractValue(argument: T): Any? {
        return fromProtoToYtMapper(argument)
    }

    companion object {
        @JvmStatic
        fun <T> column(columnDescription: ColumnDescription<*>, mapping: (T) -> Any?): ColumnMapping<T> {
            return ColumnMapping(columnDescription, mapping)
        }

        @JvmStatic
        fun <T> column(columnSchema: ColumnSchema, mapping: (T) -> Any?): ColumnMapping<T> {
            return ColumnMapping(columnSchema, mapping)
        }
    }
}
