package ru.yandex.direct.bstransport.yt.repository

import com.google.protobuf.Message
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode

/**
 * Маппинг полей таблицы в yt в функции, вычисляющие значения для этого поля
 * Схему таблицы нужно указывать с ключами
 *
 * @param <M> объект, из которого будут вычисляться значения полей
*/
open class ColumnTwoSidesMapping<M : Message, VAL, T3 : Message.Builder>(
    override val columnDescription: ColumnDescription<VAL>,
    fromProtoToYtMapper: (M) -> Any?,
    val fromYtToProtoMapper: (VAL?, T3) -> Unit)
    : ColumnMapping<M>(columnDescription, fromProtoToYtMapper) {

    fun convertToValue(node: YTreeMapNode): VAL? {
        val columnNode = if (node.getFilterNull(name).isEmpty()) null else node.get(name).get()
        return columnDescription.getValue(columnNode)
    }

    fun mapToProtoBuilder(builder: T3, row: YTreeMapNode) {
        val columnValue = convertToValue(row)
        fromYtToProtoMapper(columnValue, builder)
    }
}
