package ru.yandex.direct.bstransport.yt.repository.adgroup.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode
import java.lang.IllegalStateException

@Component
open class AdGroupDeleteYtRepository(context: BsExportYtRepositoryContext) : BaseAdGroupYtRepository(context) {
    override fun getResourceColumnSchema(): List<AdGroupResourcesColumnMapping<out Any>> {
        return listOf(
            mapper(uint64Column("DeleteTime"), { it.deleteTime }, optional { v, b -> b.deleteTime = v }))
    }

    override fun buildAdGroupFromYtRow(node: YTreeMapNode, updateTime: Long): AdGroup {
        throw IllegalStateException("Unsupported operation for AdGroupDeleteYtRepository")
    }
}
