package ru.yandex.direct.bstransport.yt.repository.adgroup.resources

import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.ColumnDescription
import ru.yandex.direct.bstransport.yt.repository.ColumnTwoSidesMapping
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupCommonYtRepository
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.yt.ytclient.tables.ColumnSortOrder

typealias AdGroupResourcesColumnMapping<V> = ColumnTwoSidesMapping<AdGroup, V, AdGroup.Builder>

abstract class BaseAdGroupYtRepository(
    context: BsExportYtRepositoryContext
) : AdGroupCommonYtRepository<AdGroup>(
    context, context.ytConfig.adGroupsTable, context.ytConfig.adGroupsQueue
) {
    abstract fun getResourceColumnSchema(): List<AdGroupResourcesColumnMapping<out Any>>

    override fun getSchemaWithMapping(): List<AdGroupResourcesColumnMapping<out Any>> {
        val keysSchemaMappers = listOf(
            mapper(uint64Column("AdGroupID", ColumnSortOrder.ASCENDING), { it.adGroupId }, { value, builder -> builder.adGroupId = value!! }),
            mapper(uint64Column("IterID"), { it.iterId }, { value, builder -> builder.iterId = value!! }),
            mapper(uint64Column("UpdateTime"), { it.updateTime }, { value, builder -> builder.updateTime = value!! }),
            mapper(uint64Column("OrderID"), { it.orderId }, { value, builder -> builder.orderId = value!! }),
        )
        val mappers = mutableListOf<AdGroupResourcesColumnMapping<out Any>>()
        mappers.addAll(keysSchemaMappers)
        mappers.addAll(getResourceColumnSchema())
        return mappers
    }

    protected fun <VAL> mapper(columnDescription: ColumnDescription<VAL>,
                               fromProtoToYtMapper: (AdGroup) -> VAL?,
                               fromYtToProtoMapper: (VAL?, AdGroup.Builder) -> Unit) =
        AdGroupResourcesColumnMapping(columnDescription, fromProtoToYtMapper, fromYtToProtoMapper)

    protected inline fun <VAL> optional(crossinline fromYtToProtoMapper: (VAL, AdGroup.Builder) -> Unit) = { value: VAL?, builder: AdGroup.Builder ->
        if (value != null) {
            fromYtToProtoMapper.invoke(value, builder)
        }
    }
}
