package ru.yandex.direct.bstransport.yt.repository.adgroup.showcondition

import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Repository
import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.direct.bstransport.yt.repository.*
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupCommonYtRepository
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode
import ru.yandex.yt.ytclient.tables.ColumnSortOrder

typealias AdGroupShowConditionMapping<V> = ColumnTwoSidesMapping<AdGroupShowCondition, V, AdGroupShowCondition.Builder>

@Repository
@Lazy(false)
open class AdGroupShowConditionYtRepository(
    private val context: BsExportYtRepositoryContext
) : AdGroupCommonYtRepository<AdGroupShowCondition>(
    context,
    context.ytConfig.adGroupShowConditionsTable,
    context.ytConfig.adGroupShowConditionsQueue
) {
    private val mappers = schemaWithMapping

    override fun getSchemaWithMapping(): List<AdGroupShowConditionMapping<out Any>> {
        return listOf(
            mapper(uint64Column("AdGroupID", ColumnSortOrder.ASCENDING), { it.adGroupId }, { value, builder -> builder.adGroupId = value!! }),
            mapper(uint64Column("Type", ColumnSortOrder.ASCENDING), { it.type.toLong() }, { value, builder -> builder.type = value!!.toInt() }),
            mapper(uint64Column("IterID"), { it.iterId }, { value, builder -> builder.iterId = value!! }),
            mapper(uint64Column("UpdateTime"), { it.updateTime }, { value, builder -> builder.updateTime = value!! }),
            mapper(protoColumn("Condition", TargetingExpression::class.java),
                { if (it.hasCondition()) it.condition else null },
                { value, builder -> if (value != null) builder.condition = value }),
        )
    }

    override fun buildAdGroupFromYtRow(node: YTreeMapNode, updateTime: Long): AdGroupShowCondition {
        val builder = AdGroupShowCondition.newBuilder()
        mappers.forEach { it.mapToProtoBuilder(builder, node) }
        builder.updateTime = updateTime
        return builder.build()
    }

    private fun <VAL> mapper(columnDescription: ColumnDescription<VAL>,
                             fromProtoToYtMapper: (AdGroupShowCondition) -> VAL?,
                             fromYtToProtoMapper: (VAL?, AdGroupShowCondition.Builder) -> Unit) =
        AdGroupShowConditionMapping(columnDescription, fromProtoToYtMapper, fromYtToProtoMapper)
}
