package ru.yandex.direct.bstransport.yt.repository.campaign

import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.ColumnDescription
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping
import ru.yandex.direct.bstransport.yt.repository.int64Column
import ru.yandex.yt.ytclient.tables.ColumnSortOrder

abstract class BaseCampaignYtRepository(
    context: BsExportYtRepositoryContext
) : BaseBsExportYtRepository<Campaign>(context, context.ytConfig.campaignsTable, context.ytConfig.campaignsQueue) {

    abstract fun getNonKeysColumnSchema(): List<ColumnMapping<Campaign>>

    override fun getSchemaWithMapping(): List<ColumnMapping<Campaign>> {
        val keysSchema = columnSchemaOf(
            Campaign::getOrderId to int64Column("OrderID", sortOrder = ColumnSortOrder.ASCENDING),
            Campaign::getExportId to int64Column("ExportID"),
        )
        return keysSchema + getNonKeysColumnSchema()
    }

    override fun delete(rows: Collection<Campaign>) {
        throw IllegalStateException("Delete operation not supported for campaigns")
    }

    protected fun columnSchemaOf(vararg mappers: Pair<(Campaign) -> Any?, ColumnDescription<*>>) =
        mappers.map { (mapper, columnDescription) -> ColumnMapping.column(columnDescription, mapper) }
}
