package ru.yandex.direct.bstransport.yt.repository.campaign

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.adv.direct.campaign.OptionalMultipliers
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.adv.direct.showcondition.RfOptions
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.boolColumn
import ru.yandex.direct.bstransport.yt.repository.customColumn
import ru.yandex.direct.bstransport.yt.repository.int64Column
import ru.yandex.direct.bstransport.yt.repository.protoColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column

@Component
class CampaignYtRepository(context: BsExportYtRepositoryContext) : BaseCampaignYtRepository(context) {

    override fun getNonKeysColumnSchema() = columnSchemaOf(
        TYPE_GETTER to stringColumn("Type"),
        CLIENT_ID_GETTER to int64Column("ClientID"),
        ARCHIVE_GETTER to boolColumn("Archive"),
        STOP_GETTER to boolColumn("Stop"),
        NAME_GETTER to stringColumn("CampaignName"),
        LAT_NAME_GETTER to stringColumn("CampaignLatName"),
        ALLOWED_ON_ADULT_CONTENT_GETTER to boolColumn("AllowedOnAdultContent"),
        MEANINGFUL_GOALS_GETTER to customColumn("MeaningfulGoals"),
        MEANINGFUL_GOALS_HASH_GETTER to uint64Column("MeaningfulGoalsHash"),
        MINUS_PHRASES_LIST_GETTER to customColumn("MinusPhrases"),
        MOBILE_APP_IDS_GETTER to customColumn("MobileAppIds"),
        DISALLOWED_TARGET_TYPES_LIST_GETTER to customColumn("DisallowedTargetTypes"),
        ROTATION_GOAL_ID_GETTER to int64Column("RotationGoalId"),
        RF_OPTIONS_GETTER to protoColumn("RfOptions", RfOptions::class.java),
        MULTIPLIERS_LIST_GETTER to protoColumn("Multipliers", OptionalMultipliers::class.java),
        SHOW_CONDITIONS_GETTER to protoColumn("ShowConditions", TargetingExpression::class.java),
        CLIENT_CHIEF_REP_LOGIN_GETTER to stringColumn("ClientChiefRepLogin"),
        CONTEXT_ID_GETTER to uint64Column("ContextID"),
        WIDGET_PARTNER_ID to uint64Column("WidgetPartnerId"),
        METRIKA_COUNTER_IDS_GETTER to customColumn("MetrikaCounterIds"),
        SOURCE_GETTER to uint64Column("Source"),
        METATYPE_GETTER to uint64Column("Metatype"),
        STRATEGY_ID_GETTER to uint64Column("StrategyId"),
        IS_WW_MANAGED_ORDER_GETTER to boolColumn("IsWwManagedOrder"),
        IS_CPM_GLOBAL_AB_SEGMENT_GETTER to boolColumn("IsCpmGlobalAbSegment"),
    )

    companion object {
        private val TYPE_GETTER = optionalMapping(Campaign::hasType, Campaign::getType)
        private val CLIENT_ID_GETTER = optionalMapping(Campaign::hasClientId, Campaign::getClientId)
        private val ARCHIVE_GETTER = optionalMapping(Campaign::hasArchive, Campaign::getArchive)
        private val STOP_GETTER = optionalMapping(Campaign::hasStop, Campaign::getStop)
        private val NAME_GETTER = optionalMapping(Campaign::hasName, Campaign::getName)
        private val LAT_NAME_GETTER = optionalMapping(Campaign::hasLatName, Campaign::getLatName)
        private val ALLOWED_ON_ADULT_CONTENT_GETTER =
            optionalMapping(Campaign::hasAllowedOnAdultContent, Campaign::getAllowedOnAdultContent)
        private val MEANINGFUL_GOALS_GETTER =
            optionalMapping(Campaign::hasMeaningfulGoals, Campaign::getMeaningfulGoals)
        private val MEANINGFUL_GOALS_HASH_GETTER =
            optionalMapping(Campaign::hasMeaningfulGoalsHash, Campaign::getMeaningfulGoalsHash)
        private val MINUS_PHRASES_LIST_GETTER = { c: Campaign -> c.minusPhrases.valuesList }
        private val MOBILE_APP_IDS_GETTER = optionalMapping(Campaign::hasMobileAppIds, Campaign::getMobileAppIds)
        private val DISALLOWED_TARGET_TYPES_LIST_GETTER = { c: Campaign -> c.disallowedTargetTypes.valuesList }
        private val ROTATION_GOAL_ID_GETTER = optionalMapping(Campaign::hasRotationGoalId, Campaign::getRotationGoalId)
        private val RF_OPTIONS_GETTER = optionalMapping(Campaign::hasRfOptions, Campaign::getRfOptions)
        private val MULTIPLIERS_LIST_GETTER = optionalMapping(Campaign::hasMultipliers, Campaign::getMultipliers)
        private val SHOW_CONDITIONS_GETTER = optionalMapping(Campaign::hasShowConditions, Campaign::getShowConditions)
        private val CLIENT_CHIEF_REP_LOGIN_GETTER =
            optionalMapping(Campaign::hasClientChiefRepLogin, Campaign::getClientChiefRepLogin)
        private val CONTEXT_ID_GETTER =
            optionalMapping(Campaign::hasContextId, Campaign::getContextId)
        private val WIDGET_PARTNER_ID = optionalMapping(Campaign::hasWidgetPartnerId, Campaign::getWidgetPartnerId)
        private val METRIKA_COUNTER_IDS_GETTER =
            optionalMapping(Campaign::hasMetrikaCounterIds, Campaign::getMetrikaCounterIds)
        private val SOURCE_GETTER = optionalMapping(Campaign::hasSource) { it.source.toLong() }
        private val METATYPE_GETTER = optionalMapping(Campaign::hasMetatype) { it.metatype.toLong() }
        private val STRATEGY_ID_GETTER = optionalMapping(Campaign::hasStrategyId) { it.strategyId }
        private val IS_WW_MANAGED_ORDER_GETTER = optionalMapping(Campaign::hasIsWwManagedOrder) { it.isWwManagedOrder }
        private val IS_CPM_GLOBAL_AB_SEGMENT_GETTER = optionalMapping(Campaign::hasIsCpmGlobalAbSegment) { it.isCpmGlobalAbSegment }
    }
}

private inline fun <T> optionalMapping(
    crossinline predicate: (T) -> Boolean,
    crossinline mapping: (T) -> Any?,
): (T) -> Any? = { it.takeIf(predicate)?.run(mapping) }
