package ru.yandex.direct.bstransport.yt.repository.dspcreative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.dspcreative.TDspCreative;
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository;
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext;
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

import static ru.yandex.direct.bstransport.yt.repository.ColumnMapping.column;
import static ru.yandex.yt.ytclient.tables.ColumnSortOrder.ASCENDING;

@Component
public class DspCreativeYtRepository extends BaseBsExportYtRepository<TDspCreative> {
    public DspCreativeYtRepository(BsExportYtRepositoryContext context) {
        super(context, context.getYtConfig().getDspCreativeTable(), context.getYtConfig().getDspCreativeQueue());
    }

    List<ColumnMapping<TDspCreative>> getNonKeysColumnSchema() {
        return List.of(
                column(new ColumnSchema("DSPID", ColumnValueType.UINT64), TDspCreative::getDSPID),
                column(new ColumnSchema("Tag", ColumnValueType.STRING), TDspCreative::getTag),
                column(new ColumnSchema("CreativeTemplateID", ColumnValueType.UINT64),
                        TDspCreative::getCreativeTemplateID),
                column(new ColumnSchema("CreativeCodeID", ColumnValueType.UINT64), TDspCreative::getCreativeCodeID),
                column(new ColumnSchema("CreateTime", ColumnValueType.UINT64), TDspCreative::getCreateTime),
                column(new ColumnSchema("UpdateTime", ColumnValueType.UINT64), TDspCreative::getUpdateTime),
                column(new ColumnSchema("ExpireTime", ColumnValueType.UINT64), TDspCreative::getExpireTime),
                column(new ColumnSchema("CreativeVersionID", ColumnValueType.UINT64),
                        TDspCreative::getCreativeVersionID),
                column(new ColumnSchema("TNSBrand", ColumnValueType.ANY), TDspCreative::getTNSBrandList),
                column(new ColumnSchema("TNSArticle", ColumnValueType.ANY), TDspCreative::getTNSArticleList),
                column(new ColumnSchema("Geo", ColumnValueType.ANY), TDspCreative::getGeoList),
                column(new ColumnSchema("Site", ColumnValueType.ANY), TDspCreative::getSiteList),
                column(new ColumnSchema("DomainList", ColumnValueType.ANY), TDspCreative::getDomainListList),
                column(new ColumnSchema("Options", ColumnValueType.UINT64), TDspCreative::getOptions),
                column(new ColumnSchema("PreModeratedObjects", ColumnValueType.STRING),
                        TDspCreative::getPreModeratedObjects),
                column(new ColumnSchema("StaticData", ColumnValueType.STRING), TDspCreative::getStaticDataJson),
                column(new ColumnSchema("Data", ColumnValueType.STRING), TDspCreative::getData),
                column(new ColumnSchema("Width", ColumnValueType.UINT64), TDspCreative::getWidth),
                column(new ColumnSchema("Height", ColumnValueType.UINT64), TDspCreative::getHeight),
                column(new ColumnSchema("MaxObjLimit", ColumnValueType.UINT64), TDspCreative::getMaxObjLimit),
                column(new ColumnSchema("MinObjLimit", ColumnValueType.UINT64), TDspCreative::getMinObjLimit),
                column(new ColumnSchema("FirstShowObjCount", ColumnValueType.UINT64),
                        TDspCreative::getFirstShowObjCount),
                column(new ColumnSchema("ParamValues", ColumnValueType.STRING), TDspCreative::getParamValuesJson),
                column(new ColumnSchema("Token", ColumnValueType.UINT64), TDspCreative::getToken),
                column(new ColumnSchema("ConstructorData", ColumnValueType.STRING),
                        TDspCreative::getConstructorDataJson),
                column(new ColumnSchema("SmartThemeID", ColumnValueType.UINT64), TDspCreative::getSmartThemeID),
                column(new ColumnSchema("SmartLayoutID", ColumnValueType.UINT64), TDspCreative::getSmartLayoutID),
                column(new ColumnSchema("SmartSizeID", ColumnValueType.UINT64), TDspCreative::getSmartSizeID)
        );
    }

    @Override
    public List<ColumnMapping<TDspCreative>> getSchemaWithMapping() {
        var keysSchemaMappers = List.of(
                column(new ColumnSchema("CreativeID", ColumnValueType.UINT64, ASCENDING),
                        TDspCreative::getCreativeID)
        );
        var mappers = new ArrayList<ColumnMapping<TDspCreative>>();
        mappers.addAll(keysSchemaMappers);
        mappers.addAll(getNonKeysColumnSchema());
        return mappers;
    }

    @Override
    public void delete(Collection<TDspCreative> rows) {
        throw new IllegalStateException("Delete operation not supported for dsp-creatives");
    }
}
