package ru.yandex.direct.bstransport.yt.repository.goals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.goals.GoalExternalTracker;
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository;
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext;
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

import static ru.yandex.direct.bstransport.yt.repository.ColumnMapping.column;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.yt.ytclient.tables.ColumnSortOrder.ASCENDING;

@Component
public class MobileGoalsExternalTrackerYtRepository extends BaseBsExportYtRepository<GoalExternalTracker> {
    public MobileGoalsExternalTrackerYtRepository(BsExportYtRepositoryContext context) {
        super(context, context.getYtConfig().getMobileGoalsExternalTrackerTable());
    }

    List<ColumnMapping<GoalExternalTracker>> getNonKeysColumnSchema() {
        return List.of(
                column(new ColumnSchema("MobileAppID", ColumnValueType.UINT64), GoalExternalTracker::getMobileAppId),
                column(new ColumnSchema("EventName", ColumnValueType.STRING), GoalExternalTracker::getEventName),
                column(new ColumnSchema("BundleID", ColumnValueType.STRING), GoalExternalTracker::getBundleId),
                column(new ColumnSchema("StoreType", ColumnValueType.STRING), GoalExternalTracker::getStoreType)
        );
    }

    @Override
    public List<ColumnMapping<GoalExternalTracker>> getSchemaWithMapping() {
        var keysSchemaMappers = List.of(
                column(new ColumnSchema("GoalID", ColumnValueType.UINT64, ASCENDING),
                        GoalExternalTracker::getGoalId)
        );
        var mappers = new ArrayList<ColumnMapping<GoalExternalTracker>>();
        mappers.addAll(keysSchemaMappers);
        mappers.addAll(getNonKeysColumnSchema());
        return mappers;
    }

    public void deleteByIds(Collection<Long> goalIds) {
        List<GoalExternalTracker> goalsToDelete = mapList(goalIds,
                id -> GoalExternalTracker.newBuilder()
                        .setGoalId(id)
                        .setMobileAppId(0L)
                        .setEventName("")
                        .setBundleId("")
                        .setStoreType("")
                        .build());
        delete(goalsToDelete);
    }
}
