package ru.yandex.direct.bstransport.yt.repository.meaningfulgoals

import org.springframework.stereotype.Repository
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.meaningfulgoals.container.MeaningfulGoalsExportInfo
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator
import ru.yandex.yt.rpcproxy.ETransactionType
import ru.yandex.yt.ytclient.proxy.ApiServiceTransaction
import ru.yandex.yt.ytclient.proxy.ApiServiceTransactionOptions
import ru.yandex.yt.ytclient.proxy.ModifyRowsRequest
import ru.yandex.yt.ytclient.tables.ColumnValueType
import ru.yandex.yt.ytclient.tables.TableSchema
import java.util.concurrent.TimeUnit

@Repository
class MeaningfulGoalsYtRepository(
        context: BsExportYtRepositoryContext,
) {
    private val ytProvider = context.ytProvider
    private val ytCluster = context.ytConfig.cluster
    private val tablePath: String = context.ytConfig.directMeaningfulGoalsTable
    private val tableSchema: TableSchema = createTableSchema()

    companion object {
        private const val CHUNK_SIZE = 50000
    }

    fun add(meaningfulGoalsObjects: Collection<MeaningfulGoalsExportInfo>) {
        val dynamicOperator = ytProvider.getDynamicOperator(ytCluster)
        meaningfulGoalsObjects.chunked(CHUNK_SIZE)
                .forEach { chunk -> add(dynamicOperator, chunk) }
    }

    private fun add(dynamicOperator: YtDynamicOperator, chunk: List<MeaningfulGoalsExportInfo>) {
        dynamicOperator.runInTransaction({ transaction -> modifyMeaningfulGoalsInternal(transaction, chunk) },
                ApiServiceTransactionOptions(ETransactionType.TT_TABLET).setSticky(true))
    }

    private fun modifyMeaningfulGoalsInternal(transaction: ApiServiceTransaction,
                                              meaningfulGoalsObjects: Collection<MeaningfulGoalsExportInfo>) {
        val request = ModifyRowsRequest(tablePath, tableSchema)
        request.setRequireSyncReplica(false)
        val inserts = meaningfulGoalsObjects.map {
            listOf(it.orderId,
                    it.meaningfulGoalsHashCode,
                    it.meaningfulGoals,
                    it.updateTime)
        }.toList()
        request.addInserts(inserts)

        transaction.modifyRows(request).get(60, TimeUnit.SECONDS)
    }

}

private fun createTableSchema() = TableSchema.Builder()
        .addKey("OrderID", ColumnValueType.INT64)
        .addKey("MeaningfulGoalsHash", ColumnValueType.UINT64)
        .addValue("MeaningfulGoalsJson", ColumnValueType.STRING)
        .addValue("UpdateTime", ColumnValueType.UINT64)
        .build()
