package ru.yandex.direct.bstransport.yt.repository.metrikacounters

import org.springframework.stereotype.Repository
import ru.yandex.adv.direct.metrikacounters.MetrikaCounters
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping.Companion.column
import ru.yandex.direct.bstransport.yt.repository.customColumn
import ru.yandex.direct.bstransport.yt.repository.int64Column
import ru.yandex.direct.bstransport.yt.repository.protoColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.direct.bstransport.yt.utils.ColumnMappingUtils
import ru.yandex.direct.bstransport.yt.utils.ColumnMappingUtils.writeProtoList
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator
import ru.yandex.yt.ytclient.proxy.ApiServiceTransaction
import ru.yandex.yt.ytclient.proxy.ModifyRowsRequest
import ru.yandex.yt.ytclient.tables.ColumnSortOrder
import ru.yandex.yt.ytclient.tables.ColumnValueType
import ru.yandex.yt.ytclient.tables.TableSchema
import java.util.concurrent.TimeUnit

@Repository
class MetrikaCountersYtRepository(
    context: BsExportYtRepositoryContext,
) : BaseBsExportYtRepository<MetrikaCounters>(context, context.ytConfig.directMetrikaCountersTable) {
    override fun getSchemaWithMapping() = listOf<ColumnMapping<MetrikaCounters>>(
        column(uint64Column("OrderID", sortOrder = ColumnSortOrder.ASCENDING)) { counters ->
            counters.orderId
        },
        column(uint64Column("MetrikaCountersHash", sortOrder = ColumnSortOrder.ASCENDING)) { counters ->
            counters.metrikaCountersHash
        },
        column(customColumn("MetrikaCounters")) { counters ->
            writeProtoList(counters.metrikaCountersList)
        },
        column(uint64Column("UpdateTime")) { counters ->
            counters.updateTime
        },
    )
}
