package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.Button
import ru.yandex.adv.direct.banner.resources.OptionalButton
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
open class BannerButtonYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(protoColumn("Button", Button::class.java),
                { resources -> if (resources.button.hasValue()) resources.button.value else null },
                { v, builder -> builder.button = if (v != null) OptionalButton.newBuilder().setValue(v).build() else OptionalButton.newBuilder().build() }))
}
