package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.FeedInfo
import ru.yandex.adv.direct.banner.resources.OptionalFeedInfo
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
open class BannerFeedInfoYtRepository(
    context: BsExportYtRepositoryContext,
) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(protoColumn("FeedInfo", FeedInfo::class.java),
                { resources -> if (resources.feedInfo.hasValue()) resources.feedInfo.value else null },
                { v, builder -> builder.feedInfo = if (v != null) OptionalFeedInfo.newBuilder().setValue(v).build() else OptionalFeedInfo.newBuilder().build() })
        )
}
