package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class BannerGreenUrlTextsYtRepository(
    context: BsExportYtRepositoryContext,
) : BaseBannerResourcesYtRepository(context) {

    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(
                stringColumn("GreenUrlTextPrefix"),
                { resource -> resource.greenUrlTextPrefix },
                { displayHrefTextPrefix, builder -> builder.greenUrlTextPrefix = displayHrefTextPrefix },
            ),
            mapper(
                stringColumn("GreenUrlTextSuffix"),
                { resource -> resource.greenUrlTextSuffix },
                { displayHrefTextSuffix, builder -> builder.greenUrlTextSuffix = displayHrefTextSuffix },
            ),
        )

}
