package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.OptionalPlatformName
import ru.yandex.adv.direct.banner.resources.PlatformName
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column

@Component
open class BannerHrefYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(stringColumn("Href"),
                { obj -> obj.href },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.href = value ?: "" }),

            mapper(stringColumn("Site"),
                { obj -> obj.site },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.site = value ?: "" }),

            mapper(stringColumn("DomainFilter"),
                { obj -> obj.domainFilter },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.domainFilter = value ?: "" }),

            mapper(stringColumn("SiteFilter"),
                { obj -> obj.siteFilter },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.siteFilter = value ?: "" }),

            mapper(uint64Column("DomainFilterID"),
                { obj -> obj.domainFilterId },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.domainFilterId = value ?: 0 }),

            mapper(uint64Column("SiteFilterID"),
                { obj -> obj.siteFilterId },
                { value, bannerResourcesBuilder -> bannerResourcesBuilder.siteFilterId = value ?: 0 }),

            mapper(protoColumn("PlatformName", PlatformName::class.java),
                { resources -> if (resources.platformName.hasValue()) resources.platformName.value else null },
                { value, bannerResourcesBuilder ->
                    bannerResourcesBuilder.platformName =
                        if (value != null)
                            OptionalPlatformName.newBuilder().setValue(value).build()
                        else OptionalPlatformName.newBuilder().build()
                }
            ))
}
