package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.LeadButton
import ru.yandex.adv.direct.banner.resources.OptionalLeadButton
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
open class BannerLeadButtonYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(protoColumn("LeadButton", LeadButton::class.java),
                { resources -> if (resources.leadButton.hasValue()) resources.leadButton.value else null },
                { v, builder -> builder.leadButton = if (v != null) OptionalLeadButton.newBuilder().setValue(v).build() else OptionalLeadButton.newBuilder().build() }))
}
