package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.Logo
import ru.yandex.adv.direct.banner.resources.OptionalLogo
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
open class BannerLogoYtRepository(context: BsExportYtRepositoryContext?) : BaseBannerResourcesYtRepository(context!!) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<Logo>>
        get() = listOf(
            mapper(protoColumn("Logo", Logo::class.java),
                { resources -> if (resources.logo.hasValue()) resources.logo.value else null },
                { value, builder -> builder.logo = if (value != null) OptionalLogo.newBuilder().setValue(value).build() else OptionalLogo.newBuilder().build() }))
}
